<?php
function gerarCodigoUnico($tamanho = 9) {
    // Caracteres permitidos
    $caracteres = '@/&%$#!=?*+1234567890';
    $quantidadeCaracteres = strlen($caracteres);
    $codigo = '';

    // Gera um código aleatório
    for ($i = 0; $i < $tamanho; $i++) {
        $codigo .= $caracteres[rand(0, $quantidadeCaracteres - 1)];
    }

    return $codigo;
}

function gerarCodigos($quantidade = 3000) {
    $codigosGerados = [];
    $tentativas = 0;

    while (count($codigosGerados) < $quantidade) {
        $codigo = gerarCodigoUnico();
        $tentativas++;

        // Verifica se o código já foi gerado
        if (!in_array($codigo, $codigosGerados)) {
            $codigosGerados[] = $codigo;
        }

        // Prevenção contra loops infinitos (caso não seja possível gerar códigos únicos)
        if ($tentativas > $quantidade * 10) {
            break;
        }
    }

    return $codigosGerados;
}

// Gera 3000 códigos
$codigos = gerarCodigos(3000);

// Exibe os códigos gerados
foreach ($codigos as $codigo) {
    echo $codigo . "<br>";
}

// Salva os códigos em um arquivo (opcional)
file_put_contents('codigos_gerados.txt', implode("\n", $codigos));

echo "Códigos gerados e salvos em 'codigos_gerados.txt'.";
?>